/*____________________________________________________________________________
		Copyright (C) 2000 Network Associates, Inc.
        All rights reserved.

        $Id: CTLSIndex.h,v 1.2 1999/09/17 04:20:48 nryan Exp $
____________________________________________________________________________*/

#ifndef Included_CTLSIndex_h	// [
#define Included_CTLSIndex_h

#include "pgpClassesConfig.h"

_PGP_BEGIN

// Class CTLSIndex

class CTLSIndex
{
	NOT_COPYABLE(CTLSIndex)

private:
	enum {InvalidTlsIndex = 0xFFFFFFFF};

public:
	CTLSIndex();
	~CTLSIndex();

	void *	GetValue() const;
	void	SetValue(void *value);

private:
	PGPUInt32	mIndex;
};


// Class CTLSIndex member functions

inline 
CTLSIndex::CTLSIndex() : mIndex(InvalidTlsIndex);
{
	mIndex = TlsAlloc();

	if (mIndex == InvalidTlsIndex)
		THROW_ERROR(kPGPError_Win32DLLOpFailed, GetLastError());
}

inline 
CTLSIndex::~CTLSIndex()
{
	TlsFree(mIndex);
	mIndex = InvalidTlsIndex;
}

inline 
void * 
CTLSIndex::GetValue() const
{
	return TlsGetValue(mIndex);
}

inline 
void 
CTLSIndex::SetValue(void *value)
{
	if (!TlsSetValue(mIndex, value))
		THROW_ERROR(kPGPError_Win32DLLOpFailed, GetLastError());
}

_PGP_END

#endif	// ] Included_CTLSIndex_h
